local jf39_gbu39_name  = 'GBU-39 SDB 285lb Guided Glide-Bomb'
local jf39_gbu39_mass  = 130.0
local quad_pylon_mass = 145.0
local dual_pylon_mass = 90.0
local jf39_gbu39_model = "jf39_gbu-39"

local jf39_gbu39_warhead = 
{
    mass                 = 6.3, 
    caliber              = 180,
    expl_mass            = 6.3,
    piercing_mass        = 6.3*1.2,
    other_factors        = { 1.0, 1.0, 1.0 },
    concrete_factors     = { 1.0, 1.0, 1.0 },
    concrete_obj_factor  = 0.0,
    obj_factors          = { 1.0, 1.0 },
    cumulative_factor    = 5.0,
    cumulative_thickness = 2.0, 
}

jf39_gbu39 =
{
    category        = CAT_MISSILES,
    name            = jf39_gbu39_name,
    user_name       = _(jf39_gbu39_name),
    scheme          = "JSOW_C",
    class_name      = "wAmmunitionCruise",
    model           = jf39_gbu39_model,
    mass            = jf39_gbu39_mass,
    
    wsTypeOfWeapon  = {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort          = 0,
    Head_Type       = 5,
    sigma           = {1, 1, 1},
    M               = jf39_gbu39_mass,
    H_max           = 28000.0,
    H_min           = 100,
    Diam            = 299.0,
    Cx_pil          = 8,
    D_max           = 115000.0,
    D_min           = 10000.0,
    Head_Form       = 1,
    Life_Time       = 9999,
    Nr_max          = 10,
    v_min           = 10.0,
    v_mid           = 200.0,
    Mach_max        = 1.7,
    t_b             = 0.0,
    t_acc           = 0.0,
    t_marsh         = 0.0,
    Range_max       = 115000.0,
    H_min_t         = 0.0,
    Fi_start        = 3.14152,
    Fi_rak          = 3.14152,
    Fi_excort       = 3.14152,
    Fi_search       = 99.9,
    OmViz_max       = 99.9,
    X_back          = 0.0,
    Y_back          = 0.0,
    Z_back          = 0.0,
    Reflection      = 0.03,
    KillDistance    = 0.0,
	
	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		12000,	19200,	18200,	24200,	26200,	27600,	28400,	28600,	
		500,	0,		0,		13400,	20600,	21600,	26800,	30000,	32000,	33400,	34400,	
		700,	0,		0,		15000,	22200,	23400,	28400,	31600,	33600,	35000,	36200,	
		1000,	0,		11000,	17200,	24400,	32400,	31000,	34400,	36400,	37800,	39000,	
		2000,	13000,	18600,	24600,	31600,	40000,	38000,	41600,	43800,	45400,	47000,	
		3000,	20400,	26000,	32000,	37200,	42400,	44000,	47600,	50000,	52000,	54800,	
		4000,	28400,	32800,	38800,	44400,	48800,	49200,	53200,	56000,	58000,	60400,	
		5000,	35200,	40000,	45200,	50800,	55600,	54800,	59200,	61600,	64400,	66800,	
		6000,	41600,	46400,	52000,	57200,	62000,	64800,	64400,	67200,	70000,	72800,	
		7000,	48000,	52800,	57600,	64000,	68000,	70400,	68800,	72000,	74400,	81600,	
		8000,	53600,	58400,	64800,	70400,	73600,	76000,	73600,	76800,	80800,	87200,	
		9000,	60000,	64800,	71200,	76000,	80000,	81600,	83200,	81600,	84400,	90400,	
		10000,	65600,	67200,	70400,	72800,	74400,	76000,	76800,	86400,	89600,	94400,	
		11000,	73200,	78000,	80400,	84000,	86400,	87600,	88800,	90000,	93600,	98400,	
		12000,	79200,	82800,	86400,	90000,	92400,	92400,	92400,	93600,	97200,	102000,	
		13000,	84000,	87600,	92400,	93600,	96000,	97200,	98400,	98400,	99600,	104400,	
		14000,	88800,	92400,	96000,	99600,	102000,	103200,	103200,	104400,	104400,	106800,	
		15000,	93000,	98000,	101000,	104000,	106000,	108000,	108000,	109000,	112000,	115000,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		8400,	9000,	9000,	9600,	9800,	9800,	10000,	10000,	
		500,	0,		0,		8600,	9200,	9400,	9800,	10000,	10200,	10400,	10400,	
		700,	0,		0,		8800,	9400,	9400,	10000,	10200,	10400,	10600,	10600,	
		1000,	0,		8400,	9000,	9600,	10200,	10200,	10400,	10600,	10800,	10800,	
		2000,	8600,	9000,	9600,	10200,	11000,	10800,	11200,	11400,	11400,	11600,	
		3000,	9200,	9600,	10400,	10800,	11200,	11600,	11600,	12000,	12000,	12000,	
		4000,	10000,	10400,	10800,	11600,	12000,	12000,	12400,	12400,	12800,	12800,	
		5000,	10800,	11200,	11600,	12000,	12400,	12400,	12800,	12800,	13200,	13600,	
		6000,	11200,	11600,	12000,	12400,	13200,	13200,	13200,	13600,	13600,	14000,	
		7000,	12000,	12000,	12800,	13600,	13600,	13600,	13600,	14400,	14400,	14000,	
		8000,	12800,	12800,	13600,	13600,	14400,	14400,	14400,	14400,	15200,	14600,	
		9000,	12800,	13600,	14400,	14400,	15200,	15200,	15200,	15200,	15800,	15800,	
		10000,	13600,	13600,	13600,	14400,	14400,	14400,	14400,	15200,	16000,	16000,	
		11000,	13200,	14400,	14400,	14400,	14400,	14400,	15600,	15600,	15600,	15600,	
		12000,	14400,	14400,	14400,	15600,	15600,	15600,	15600,	15600,	15600,	16800,	
		13000,	14400,	14400,	15600,	15600,	15600,	15600,	15600,	15600,	15600,	16800,	
		14000,	15600,	15600,	15600,	15600,	16800,	16800,	16800,	16800,	16800,	13200,	
		15000,	15600,	15600,	15600,	16800,	16800,	16800,	16800,	16800,	16800,	18000,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		78.7,	116,	82.3,	101.7,	103.1,	103.6,	102.3,	98.2,		
		500,	0,		0,		87,		123.5,	100.2,	114.9,	122.6,	126.4,	128.2,	128.1,	
		700,	0,		0,		96.8,	132.5,	109.4,	122.6,	130.1,	133.7,	135.4,	136.3,	
		1000,	0,		83.3,	109.3,	144.1,	180.3,	135.6,	143.9,	147.3,	148.7,	149.2,	
		2000,	108.4,	131.6,	149.3,	175.6,	215.9,	169.6,	178.1,	181.8,	183.5,	185.3,	
		3000,	149.1,	171.5,	186.4,	194.2,	204.4,	196.2,	203.7,	207.9,	211.4,	220.5,	
		4000,	189.6,	202.1,	216.7,	226,	228.9,	216.1,	225.8,	231.8,	234.1,	238.9,	
		5000,	218,	233.3,	242.6,	250.4,	255.4,	239,	250.5,	252.9,	259.4,	262.4,	
		6000,	242.3,	257.1,	270.6,	274.1,	278.2,	280.8,	270.4,	274.7,	279.8,	284,	
		7000,	266,	280.1,	288.2,	300.2,	298.5,	299.6,	285.1,	291.4,	292.5,	325.8,	
		8000,	283.2,	296.6,	316.5,	322.6,	317.2,	319.1,	303.1,	308.6,	319.2,	345.2,	
		9000,	306.2,	318.7,	339.4,	339.9,	342.6,	339.2,	340.7,	326.4,	332.9,	352.5,	
		10000,	320.8,	308.4,	307.2,	303.7,	301.4,	303,	301.4,	345.2,	347.7,	358.6,	
		11000,	354,	363.4,	354.1,	357.9,	359.8,	357.7,	358.9,	356.5,	360.9,	370.6,	
		12000,	377,	378,	379,	383.6,	385.3,	374.2,	367.3,	368.7,	374.6,	383.3,	
		13000,	393.1,	394.7,	405.9,	392.7,	394.1,	391,	392.7,	385.4,	383.2,	392.2,	
		14000,	411.6,	413.3,	415.5,	420.3,	420.8,	417.7,	410.8,	411.4,	400.9,	396.8,	
		15000,	422,	433.5,	435.5,	440,	430.6,	428.8,	421.5,	421.2,	428,	424.3,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		50.4,	45.3,	35.6,	34.1,	32.1,	29.5,	28.2,	27.1,		
		500,	0,		0,		52,		45.1,	36.4,	35,		32.6,	31,		29.7,	27.6,		
		700,	0,		0,		52.1,	45.6,	36,		34.9,	32.6,	31.3,	29.8,	27.8,		
		1000,	0,		61.4,	52.1,	46.1,	42.9,	37.3,	34.4,	32.8,	31.4,	29.2,		
		2000,	66.6,	58,		52.1,	47.9,	44.6,	37.1,	35.4,	34.2,	32.1,	30.7,		
		3000,	65.1,	58.8,	54.8,	49.4,	45.8,	39.9,	36.8,	36,		34.2,	31.8,		
		4000,	66.7,	61.6,	54.6,	50.2,	45.9,	41.5,	39.9,	37.1,	35.9,	33.7,		
		5000,	68.2,	64,		56.9,	51.4,	47.6,	40.9,	40.8,	37,		35.1,	33.7,		
		6000,	67.6,	64.4,	57.9,	53,		50.5,	50.6,	42.5,	39.8,	36.8,	34.9,		
		7000,	68.8,	64.9,	60.6,	56.9,	55.8,	52.9,	44.3,	42.6,	39.3,	35.5,	
		8000,	70.5,	66.9,	63.3,	57.8,	59.1,	52.8,	49.9,	43.7,	41.7,	35.6,	
		9000,	69.7,	69.1,	66.4,	61,		58.9,	56,		53.9,	45.8,	38.4,	36.5,		
		10000,	73.8,	66,		61.7,	59.4,	55.9,	53.3,	51.2,	49,		46.8,	44.2,		
		11000,	68.1,	66,		61.2,	57.3,	54.4,	52.1,	52.9,	50.9,	45.1,	43,		
		12000,	72.3,	66.9,	62.3,	61.4,	58.4,	56,		54,		51.9,	50.1,	45.7,		
		13000,	73.1,	68,		66.4,	62.7,	59.6,	57.2,	55,		52.9,	50.4,	46.9,		
		14000,	77.3,	72.1,	67.6,	63.9,	63.5,	60.9,	58.6,	56.3,	53.4,	45.2,		
		15000,	78.2,	73.3,	68.9,	67.8,	64.7,	62,		59.6,	57.1,	54,		52.7,		
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		64.4,	77.2,	57.3,	63.4,	62.1,	61.2,	60.1,	57.5,		
		500,	0,		0,		67.8,	80.8,	66,		69.1,	69.9,	70,		69.6,	68.2,		
		700,	0,		0,		72,		84.1,	69.6,	72.2,	73,		73.1,	72.7,	71.6,		
		1000,	0,		71,		77.1,	87.7,	102.5,	77.3,	78.6,	78.6,	78.2,	77,		
		2000,	87.2,	91.5,	94.2,	100,	119.8,	91,		92.9,	93.2,	92.5,	92.1,		
		3000,	105.6,	109.3,	110.8,	109.5,	109.6,	102.9,	103.8,	104.7,	104.5,	131.3,	
		4000,	123.7,	124.1,	123.5,	123.3,	120.8,	112.1,	114.7,	109.4,	109.7,	109.7,	
		5000,	136.3,	138.4,	135.5,	133.5,	131.7,	122.2,	119.1,	118.9,	120.4,	120.5,	
		6000,	145.8,	148.1,	146.9,	143.2,	142.7,	141.9,	128,	131.1,	131.1,	133.8,	
		7000,	155.7,	157.1,	155.7,	155.4,	152.3,	150.9,	134.2,	137.7,	137.5,	137.4,	
		8000,	163.1,	164.6,	167.6,	164.3,	162,	160.7,	150.7,	144,	148.4,	150.9,	
		9000,	170.1,	173.5,	177.3,	173.7,	173.5,	170.5,	169.2,	152.1,	154.2,	156.6,		
		10000,	173.8,	167.5,	163.1,	159.9,	156.4,	154.8,	152.6,	158.6,	159.9,	161.5,	
		11000,	183.9,	186.3,	180.5,	178.7,	177.1,	174.6,	175.4,	163.4,	163,	163.7,	
		12000,	194.2,	192.1,	189.4,	190.2,	188.4,	183.5,	179.5,	177.7,	165.9,	168.4,	
		13000,	199.9,	198.2,	200.8,	194.6,	192.7,	189.9,	188,	183.6,	179.8,	168.4,	
		14000,	208.6,	207.1,	205,	203.6,	203.8,	200.9,	196.4,	193.9,	187.7,	174.1,		
		15000,	214.7,	218.1,	214.9,	212.2,	209,	207.5,	202.8,	199.4,	196.3,	188.6,	
	},
	
    shape_table_data =
    {
        {
            name     = jf39_gbu39_name,
            file     = jf39_gbu39_model,
            life     = 1,
            fire     = { 0, 1},
            username = jf39_gbu39_name,
            index    = WSTYPE_PLACEHOLDER,
        },
    },

	fm =	{
		mass				= 275.0,
		caliber				= 0.299,
		cx_coeff            = {1, 0.82, 0.8, 0.18, 1.5},
		L					= 2.48,
		I					= 1 / 12 * 275.0 * 2.48 * 2.48,
		Ma					= 2,
		Mw					= 7,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		Sw					= 0.4,
		dCydA				= {0.07, 0.036},
		A					= 0.15,
		maxAoa				= 0.4,
		finsTau				= 0.2,
		Ma_x				= 2,
		Ma_z				= 2,
		Mw_x				= 1.4,

		addDeplSw			= 0.5,
		no_wings_A_mlt		= 2,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 9999,
		no_wings_cx_coeff	= {1, 0.42, 0.8, 0.10, 1.52},
		
		release_rnd		= 0.3,
		release_rnd_x	= 0.0,
	},
	
	seeker = {
		coalition						= 1,
		coalition_rnd_coeff				= 5.0,
		can_update_target_pos			= 1,
	},

	control_block =	{
		seeker_activation_dist		= 7000,
		default_cruise_height		= -1,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 2.2,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
		wo_wings_no_fin_stage		= 1,
		no_fin_stage_dive			= 0.5,
	},

	autopilot =	{
		delay						= 0.3,
		K							= 115,
		Ki							= 0.00008,
		Kg							= 2.6,
		nw_K						= 45,
		nw_Ki						= 0.00008,
		nw_Kg						= 1.6,
		finsLimit					= 0.8,
		useJumpByDefault			= 0,
		J_Power_K					= 4.8,
		J_Diff_K					= 3.2,
		J_Int_K						= 0.0,
		J_Angle_W					= 0.1,
		hKp_err						= 50,
		Kxd							= 0.0,
		K_err_mlt					= 5.0,
		K_roll_diff_mlt				= 5.0,
		roll_limit					= 1.3,
		w_limit						= 1.3,
		fins_limit_x				= 0.25,
		egm_Angle_K					= 0.2,
		egm_FinAngle_K				= 0.3,
		egm_add_power_K				= 0.2,
		wings_depl_fins_limit_K		= 0.3,
		err_new_wlos_k				= 1.0,
		err_aoaz_k					= 0,
		err_aoaz_sign_k				= 0.0,
		
		alternative_roll_params	= 1,
		w_x_limit		= 0.5,
		err_limit		= 0.05,
		err_min			= 0.01,
		corr_err_min	= 0.006,
		roll_limit		= 0.9,
		fins_limit_x	= 0.04,
		K_err_mlt		= 4.0,
		K_roll_diff_mlt	= 10.0,
		Kx				= 0.04,
		
		alternative_jump_params	= 1,
		K_pitch_diff_mlt	= 5.0,
		w_limit				= 0.5,
		Kpj					= 0.5,	
	},	
	
    warhead     = jf39_gbu39_warhead,
    warhead_air = jf39_gbu39_warhead,	
}
declare_weapon(jf39_gbu39)

declare_loadout({
    category         = CAT_BOMBS,
    CLSID            = "DIS_LS_6_500",	
	Count            = 4,
    Cx_pil           = 0.0012 * 4 + 0.00122,
    Cx_item          = 0.0012,
    Picture          = "jf39_gbu39.png",
	displayName      = _(jf39_gbu39_name .. " x4"),
	Weight           = 664,
    Elements = {
        {
            ShapeName = "jf39_bru_61",
            IsAdapter = true
        },
        {
			connector_name =	"AttachPoint001",
			ShapeName	=	"jf39_gbu39_model",
			Rotation = {0,0,0},
        },
        {
			connector_name =	"AttachPoint002",		
			ShapeName	=	"jf39_gbu39_model",
			Rotation = {0,0,0},
        },
        {
			connector_name =	"AttachPoint003",		
			ShapeName	=	"jf39_gbu39_model",
			Rotation = {0,0,0},
        },
        {
			connector_name =	"AttachPoint004",		
			ShapeName	=	"jf39_gbu39_model",
			Rotation = {0,0,0},
        },
    },
	wsTypeOfWeapon   = jf39_gbu39.wsTypeOfWeapon,
    attribute        = {4, 4, 32, WSTYPE_PLACEHOLDER},
    ejectVelocity    = eject_speed_msl1,
	ejectDirection   = {0, -1, 0},
})

---------------------------------------------------

local jf39_spear3_name  = 'SPEAR-3 Air-to-Ground Glide Missile'
local jf39_spear3_mass  = 90
local jf39_spear3_model = 'jf39_spear-3'

local jf39_spear3_warhead =
{
    mass                 = 6.3, 
    caliber              = 180,
    expl_mass            = 6.3,
    piercing_mass        = 6.3*1.2,
    other_factors        = { 1.0, 1.0, 1.0 },
    concrete_factors     = { 1.0, 1.0, 1.0 },
    concrete_obj_factor  = 0.0,
    obj_factors          = { 1.0, 1.0 },
    cumulative_factor    = 5.0,
    cumulative_thickness = 2.0, 
}

jf39_spear3 =
{
	category        = CAT_MISSILES,
    name            = jf39_spear3_name,
    user_name       = _(jf39_spear3_name),
    model           = jf39_spear3_model,
    mass            = jf39_spear3_mass,
	scheme			= "sat_cruise_missile",             
	class_name		= "wAmmunitionCruise",     
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Missile, wsType_AS_Missile, WSTYPE_PLACEHOLDER},
	
	Escort = 0,
    Head_Type = 3,
	sigma = {1, 1, 1},
    M = jf39_spear3_mass,
    H_max = 15000.0,
    H_min = -1,
    Diam = 180.0,
    Cx_pil = 2,
    D_max = 140000.0,
    D_min = 500.0,
    Head_Form = 0,
    Life_Time = 500,
    Nr_max = 25,
    v_min = 50.0,
    v_mid = 320.0,
    Mach_max = 2.0,
    t_b = 0.0,
    t_acc = 1.0,
    t_marsh = 9999.0,
    Range_max = 140000.0,
    H_min_t = 0.0,
    Fi_start = 0.5,
    Fi_rak = 3.14152,
    Fi_excort = 1.05,
    Fi_search = 99.9,
    OmViz_max = 99.9,
	exhaust	= {1.0, 1.0, 1.0, 0.1},
	X_back	= -0.9,
	Y_back	= -0.15,
	Z_back 	= 0.0,
	Reflection	= 0.012,
	KillDistance= 0.0,
	add_attributes = {"Cruise missiles"},	
	
	manualWeaponFlag = 1,

LaunchDistData =
{
	18,		10,

			100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
	300,	0,		0,		48000,	76800,	72800,	96800,	104800,	110400,	113600,	114400,	
	500,	0,		0,		53600,	82400,	86400,	107200,	120000,	128000,	133600,	137600,	
	700,	0,		0,		60000,	88800,	93600,	113600,	126400,	134400,	140000,	144800,	
	1000,	0,		44000,	68800,	97600,	129600,	124000,	137600,	145600,	151200,	156000,	
	2000,	52000,	74400,	98400,	126400,	160000,	152000,	166400,	175200,	181600,	188000,	
	3000,	81600,	104000,	128000,	148800,	169600,	176000,	190400,	200000,	208000,	219200,	
	4000,	113600,	131200,	155200,	177600,	195200,	196800,	212800,	224000,	232000,	241600,	
	5000,	140800,	160000,	180800,	203200,	222400,	219200,	236800,	246400,	257600,	267200,	
	6000,	166400,	185600,	208000,	228800,	248000,	259200,	257600,	268800,	280000,	291200,	
	7000,	192000,	211200,	230400,	256000,	272000,	281600,	275200,	288000,	297600,	326400,	
	8000,	214400,	233600,	259200,	281600,	294400,	304000,	294400,	307200,	323200,	348800,	
	9000,	240000,	259200,	284800,	304000,	320000,	326400,	332800,	326400,	337600,	361600,	
	10000,	262400,	268800,	281600,	291200,	297600,	304000,	307200,	345600,	358400,	377600,	
	11000,	292800,	312000,	321600,	336000,	345600,	350400,	355200,	360000,	374400,	393600,	
	12000,	316800,	331200,	345600,	360000,	369600,	369600,	369600,	374400,	388800,	408000,	
	13000,	336000,	350400,	369600,	374400,	384000,	388800,	393600,	393600,	398400,	417600,	
	14000,	355200,	369600,	384000,	398400,	408000,	412800,	412800,	417600,	417600,	427200,	
	15000,	372000,	392000,	404000,	416000,	424000,	432000,	432000,	436000,	448000,	460000,	
},


	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		8400,	9000,	9000,	9600,	9800,	9800,	10000,	10000,	
		500,	0,		0,		8600,	9200,	9400,	9800,	10000,	10200,	10400,	10400,	
		700,	0,		0,		8800,	9400,	9400,	10000,	10200,	10400,	10600,	10600,	
		1000,	0,		8400,	9000,	9600,	10200,	10200,	10400,	10600,	10800,	10800,	
		2000,	8600,	9000,	9600,	10200,	11000,	10800,	11200,	11400,	11400,	11600,	
		3000,	9200,	9600,	10400,	10800,	11200,	11600,	11600,	12000,	12000,	12000,	
		4000,	10000,	10400,	10800,	11600,	12000,	12000,	12400,	12400,	12800,	12800,	
		5000,	10800,	11200,	11600,	12000,	12400,	12400,	12800,	12800,	13200,	13600,	
		6000,	11200,	11600,	12000,	12400,	13200,	13200,	13200,	13600,	13600,	14000,	
		7000,	12000,	12000,	12800,	13600,	13600,	13600,	13600,	14400,	14400,	14000,	
		8000,	12800,	12800,	13600,	13600,	14400,	14400,	14400,	14400,	15200,	14600,	
		9000,	12800,	13600,	14400,	14400,	15200,	15200,	15200,	15200,	15800,	15800,	
		10000,	13600,	13600,	13600,	14400,	14400,	14400,	14400,	15200,	16000,	16000,	
		11000,	13200,	14400,	14400,	14400,	14400,	14400,	15600,	15600,	15600,	15600,	
		12000,	14400,	14400,	14400,	15600,	15600,	15600,	15600,	15600,	15600,	16800,	
		13000,	14400,	14400,	15600,	15600,	15600,	15600,	15600,	15600,	15600,	16800,	
		14000,	15600,	15600,	15600,	15600,	16800,	16800,	16800,	16800,	16800,	13200,	
		15000,	15600,	15600,	15600,	16800,	16800,	16800,	16800,	16800,	16800,	18000,	
	},

	MaxTOF =
	{
		36,		20,
	
				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		314.8,	464,	329.2,	406.8,	412.4,	414.4,	409.2,	392.8,		
		500,	0,		0,		348,	494,	400.8,	459.6,	490.4,	505.6,	512.8,	512.4,	
		700,	0,		0,		387.2,	530,	437.6,	490.4,	520.4,	534.8,	541.6,	545.2,	
		1000,	0,		333.2,	437.2,	576.4,	721.2,	542.4,	575.6,	589.2,	594.8,	596.8,	
		2000,	433.6,	526.4,	597.2,	702.4,	863.6,	678.4,	712.4,	727.2,	734,	741.2,	
		3000,	596.4,	686,	745.6,	776.8,	817.6,	784.8,	814.8,	831.6,	845.6,	882,	
		4000,	758.4,	808.4,	866.8,	904,	915.6,	864.4,	903.2,	927.2,	936.4,	955.6,	
		5000,	872,	933.2,	970.4,	1001.6,	1021.6,	956,	1002,	1011.6,	1037.6,	1049.6,	
		6000,	969.2,	1028.4,	1082.4,	1096.4,	1112.8,	1123.2,	1081.6,	1098.8,	1119.2,	1136,	
		7000,	1064,	1120.4,	1152.8,	1200.8,	1194,	1198.4,	1140.4,	1165.6,	1170,	1303.2,	
		8000,	1132.8,	1186.4,	1266,	1290.4,	1268.8,	1276.4,	1212.4,	1234.4,	1276.8,	1380.8,	
		9000,	1224.8,	1274.8,	1357.6,	1359.6,	1370.4,	1356.8,	1362.8,	1305.6,	1331.6,	1410,	
		10000,	1283.2,	1233.6,	1228.8,	1214.8,	1205.6,	1212,	1205.6,	1380.8,	1390.8,	1434.4,	
		11000,	1416,	1453.6,	1416.4,	1431.6,	1439.2,	1430.8,	1435.6,	1426,	1443.6,	1482.4,	
		12000,	1508,	1512,	1516,	1534.4,	1541.2,	1496.8,	1469.2,	1474.8,	1498.4,	1533.2,	
		13000,	1572.4,	1578.8,	1623.6,	1570.8,	1576.4,	1564,	1570.8,	1541.6,	1532.8,	1568.8,	
		14000,	1646.4,	1653.2,	1662,	1681.2,	1683.2,	1670.8,	1643.2,	1645.6,	1603.6,	1587.2,	
		15000,	1688,	1734,	1742,	1760,	1722.4,	1715.2,	1686,	1684.8,	1712,	1697.2,	
	},
	

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		50.4,	45.3,	35.6,	34.1,	32.1,	29.5,	28.2,	27.1,		
		500,	0,		0,		52,		45.1,	36.4,	35,		32.6,	31,		29.7,	27.6,		
		700,	0,		0,		52.1,	45.6,	36,		34.9,	32.6,	31.3,	29.8,	27.8,		
		1000,	0,		61.4,	52.1,	46.1,	42.9,	37.3,	34.4,	32.8,	31.4,	29.2,		
		2000,	66.6,	58,		52.1,	47.9,	44.6,	37.1,	35.4,	34.2,	32.1,	30.7,		
		3000,	65.1,	58.8,	54.8,	49.4,	45.8,	39.9,	36.8,	36,		34.2,	31.8,		
		4000,	66.7,	61.6,	54.6,	50.2,	45.9,	41.5,	39.9,	37.1,	35.9,	33.7,		
		5000,	68.2,	64,		56.9,	51.4,	47.6,	40.9,	40.8,	37,		35.1,	33.7,		
		6000,	67.6,	64.4,	57.9,	53,		50.5,	50.6,	42.5,	39.8,	36.8,	34.9,		
		7000,	68.8,	64.9,	60.6,	56.9,	55.8,	52.9,	44.3,	42.6,	39.3,	35.5,	
		8000,	70.5,	66.9,	63.3,	57.8,	59.1,	52.8,	49.9,	43.7,	41.7,	35.6,	
		9000,	69.7,	69.1,	66.4,	61,		58.9,	56,		53.9,	45.8,	38.4,	36.5,		
		10000,	73.8,	66,		61.7,	59.4,	55.9,	53.3,	51.2,	49,		46.8,	44.2,		
		11000,	68.1,	66,		61.2,	57.3,	54.4,	52.1,	52.9,	50.9,	45.1,	43,		
		12000,	72.3,	66.9,	62.3,	61.4,	58.4,	56,		54,		51.9,	50.1,	45.7,		
		13000,	73.1,	68,		66.4,	62.7,	59.6,	57.2,	55,		52.9,	50.4,	46.9,		
		14000,	77.3,	72.1,	67.6,	63.9,	63.5,	60.9,	58.6,	56.3,	53.4,	45.2,		
		15000,	78.2,	73.3,	68.9,	67.8,	64.7,	62,		59.6,	57.1,	54,		52.7,		
	},

	MidTOF =
	{
		36,		20,
	
				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		257.6,	308.8,	229.2,	253.6,	248.4,	244.8,	240.4,	230,		
		500,	0,		0,		271.2,	323.2,	264,	276.4,	279.6,	280,	278.4,	272.8,		
		700,	0,		0,		288,	336.4,	278.4,	288.8,	292,	292.4,	290.8,	286.4,		
		1000,	0,		284,	308.4,	350.8,	410,	309.2,	314.4,	314.4,	312.8,	308,		
		2000,	348.8,	366,	376.8,	400,	479.2,	364,	371.6,	372.8,	370,	368,		
		3000,	420.4,	434.4,	448.8,	470,	520.4,	485.2,	488.8,	490.4,	486.4,	480.8,		
		4000,	491.2,	504.4,	520.4,	538.8,	568.8,	550.4,	552.4,	552.8,	548.4,	543.6,		
		5000,	560,	574,	590,	609.2,	637.2,	616.4,	617.6,	616.8,	612,	606,		
		6000,	628.8,	643.6,	661.6,	683.2,	708.8,	684.4,	682,	679.6,	674,	666.4,		
		7000,	694.8,	710.4,	728.8,	753.6,	781.2,	756.8,	751.2,	747.6,	740.8,	732,		
		8000,	758.4,	775.2,	794.8,	822.8,	850.4,	824.8,	817.6,	812.8,	804.4,	794,		
		9000,	820.8,	838.8,	859.6,	891.2,	912.8,	884,	875.2,	869.2,	860.4,	848.4,		
		10000,	880.8,	900.4,	922.4,	956,	976.4,	948.8,	936,	928.4,	917.2,	903.2,		
		11000,	939.2,	960.8,	984.8,	1019.2,	1036.8,	1011.6,	996,	986,	974.8,	958,		
		12000,	995.2,	1018.8,	1044.8,	1080,	1096,	1074.8,	1056,	1044,	1030.8,	1012,		
		13000,	1049.6,	1075.2,	1102.8,	1138,	1152.4,	1132.4,	1112,	1096,	1080.8,	1060.8,		
		14000,	1102.4,	1130.4,	1158.8,	1193.2,	1206,	1190,	1168.8,	1152.8,	1136.8,	1116,		
		15000,	1153.6,	1183.6,	1213.6,	1247.2,	1258,	1244.8,	1224,	1206,	1188.8,	1168,		
	},
	
		shape_table_data =
	{
		{
			name     = jf39_spear3_name,
			file     = jf39_spear3_model,
			life     = 1,
			fire     = {0, 1},
			username = "JAS39 SPEAR-3",
			index    = WSTYPE_PLACEHOLDER,
		},
	},

	controller = {
		boost_start	= 2.00,
		march_start = 5.00,
	},
	
	fm = {
		mass        = 675,  
		caliber     = 0.343,  
		cx_coeff    = {1, 0.3, 0.65, 0.023, 1.6},
		L           = 4.37,
		I           = 1500,
		Ma          = 3,	
		Mw          = 10,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 1.2,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
	},
	
	seeker = {
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
		can_update_target_pos	= 1,
	},
	
	control_block ={
		seeker_activation_dist		= 40000, 
		default_cruise_height		= 10000, 
		obj_sensor					= 0,
		can_update_target_pos		= 1,
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.8,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
		use_horiz_dist				= 1,
	},
	
	final_autopilot =		{
		delay 				= 0,
		K					= 60,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 1,
		J_Power_K			= 1.5,
		J_Diff_K			= 0.4,
		J_Int_K				= 0,
		J_Angle_K			= 0.18,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.8,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	cruise_autopilot = {
		delay				= 1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 9,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 50,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.8,
		max_start_y_vel		= 35,
		stab_vel			= 237.5,
		finsLimit			= 0.8,
		estimated_N_max		= 6,
		eng_min_thrust		= -100,
		eng_max_thrust		= 1500,		
	},
	
	boost = {	--	air launch - no booster
		impulse								= 100,
		fuel_mass							= 23,
		work_time							= 3,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{-0.8, 0.0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0,
		smoke_color							= {0.9, 0.9, 0.9},
		smoke_transparency					= 0.7,
		custom_smoke_dissipation_factor		= 0.2,						
	},
	
	booster_animation = {
		start_val = 0,
	},
	
	play_booster_animation = {
		val = 0,
	},
	
	march = {
		impulse			= 600,
		fuel_mass		= 77.5,
		work_time		= 800,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 1500,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-0.8, 0.0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.2,
		smoke_color							= {0.9, 0.9, 0.9},
		smoke_transparency					= 0.7,
		custom_smoke_dissipation_factor		= 0.2,		
		
		start_burn_effect			= 0,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
		
	},
	
	--warhead = jf39_spear3_warhead,
	--warhead_air = jf39_spear3_warhead,
	warhead     = predefined_warhead("LS_6_250"),
	warhead_air = predefined_warhead("LS_6_250"),	
	
}

declare_weapon(jf39_spear3)

declare_loadout({
    category        = CAT_MISSILES,
    CLSID           = 'DIS_LS_6_250',
    wsTypeOfWeapon  = jf39_spear3.wsTypeOfWeapon,
    attribute       = {4, 4, 32, WSTYPE_PLACEHOLDER},
    Count           = 3,
    Cx_pil           = 0.0012 * 3 + 0.00122,
    Cx_item          = 0.0012,
    Picture         = "jf39_spear-3.png",
    displayName     = _(jf39_spear3_name .. ' x3'),
    Weight          = 360,
    ejectVelocity   = eject_speed_msl1,
    ejectDirection  = {0, -1, 0},
	Elements = {
	
		{
			ShapeName	=	"jf39_spear_triple_rack",
			IsAdapter = true,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{-0.15,	-0.42,	0.25}, --1
			ShapeName	=	jf39_spear3_model,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{-0.15,	-0.42,	-0.25}, --2
			ShapeName	=	jf39_spear3_model,
		},
		
		{
			DrawArgs = {[1] = {1,1},[2] = {2,1},},
			Position	=	{-0.15,	-0.50, 0.0}, --3
			ShapeName	=	jf39_spear3_model,
		},		
		
	},
})
